# Лабораторна робота №6

## Розгортання обчислювальних сервісів в Azure (Virtual Machines, App Service, Container Instances)

**Мета**: ознайомитися з основними обчислювальними сервісами Microsoft Azure та відпрацювати практику розгортання і керування віртуальними машинами (Azure Virtual Machines, Azure Virtual Machine Scale Sets), вебзастосунками (Azure App Service) та контейнерними робочими навантаженнями (Azure Container Instances). Навчитися підбирати відповідний сервіс залежно від сценарію, оптимізувати параметри продуктивності й вартості, а також забезпечувати масштабування, стійкість і безпечний доступ до ресурсів.

---

## Хід роботи

### Azure Virtual Machine (кроки 1–9)

1. Переконайтеся, що політика **Allowed resource deployment regions** дозволяє вибраний регіон, та створіть у Azure Portal віртуальну машину: **Create > Virtual Machine**, змінюючи тільки наведені параметри.

   - Basics:
     - Subscription: Azure for Students.
     - Resource group: `rg-vm-xxx-yyy-zzz`, де `xxx` — код регіону з довідника, `yyy` — ініціали, `zzz` — номер варіанту.
     - Virtual machine name: `vm-xxx-yyy-zzz-001`.
     - Region: один із дозволених регіонів політики.
     - Availability options: Availability set.
     - Availability set: Create new → Name `as-xxx-yyy-zzz-001`, Fault domains `2`, Update domains `6`.
     - Security type: Trusted launch virtual machines.
     - Image: Windows Server 2025 Datacenter – x64 Gen2.
     - Size: Standard_B2s (2 vCPU, 4 GiB RAM).
     - Username: такий самий, як в Azure Cloud Shell (наприклад, `ki251_mvv`).
     - Password: безпечний пароль ≥ 12 символів (у звіті не вказувати).
     - Public inbound ports: None.

   - Disks:
     - OS disk type: Standard SSD (LRS).
     - Create and attach a new disk: Standard SSD (LRS), Size `32 GiB`, увімкнути опцію Delete disk with VM.

   - Networking:
     - Virtual network → Edit: адресний простір `10.xxx.0.0/16`, де `xxx` = номер варіанту.
     - Наявний subnet налаштувати на префікс `/29` у полі IPv4 address range.

   Після перевірки параметрів перейдіть до Review + Create та натисніть Create.

2. Дозвольте RDP-доступ до машини: Virtual Machine → Networking → Network settings → Create port rule → Inbound port rule. Задайте:
   - Source: `My IP address`
   - Source port ranges: `*`
   - Destination: `Any`
   - Service: `RDP`
   - Action: `Allow`
   - Priority: `110`
   - Name: `allow-rdp`
   - Description: довільний опис

   Збережіть правило.

3. У тій самій панелі оберіть Connect → Connect, натисніть Check access і переконайтеся, що зʼявився напис "Port 3389 is accessible from source IP(s)". Завантажте RDP-файл (Download RDP file).

4. Підʼєднайтесь до VM через Microsoft Remote Desktop, використовуючи завантажений RDP-файл та облікові дані, створені на кроці 1.

5. У File Explorer зафіксуйте наявні Devices and drives (Windows (C:), Temporary Storage (D:), DVD Drive (E:)). Ініціалізуйте додатковий диск через Disk Management:
   - ПКМ по меню Start → Disk Management → погодитися на ініціалізацію диска (ймовірно Disk 2 ~31.98 GB) → New Simple Volume → майстер за замовчуванням.
   - Перевірте появу нового тому (~31.9 GB) у File Explorer.

6. У PowerShell всередині VM виконайте встановлення IIS:

    ```powershell
    Install-WindowsFeature -Name Web-Server -IncludeManagementTools
    ```

   Поверніться до Azure Portal, на сторінці VM → Overview скопіюйте Primary NIC public IP та відкрийте її через HTTP у браузері. Очікувана помилка свідчить про відсутність правила HTTP.

7. Створіть inbound-правило для HTTP: Virtual Machine → Networking → Network settings → Create port rule → Inbound port rule з параметрами:
   - Source: `Any`
   - Source port ranges: `*`
   - Destination: `Any`
   - Service: `HTTP`
   - Action: `Allow`
   - Priority: `120`
   - Name: `allow-http`

   Збережіть.

8. Повторно відкрийте публічну IP-адресу через HTTP та переконайтеся в доступі до стандартної сторінки IIS.

9. Розірвіть RDP-сеанс і видаліть створені ресурси, щоб звільнити кредити.

---

### Virtual Machine Scale Set та балансування (кроки 10–18)

10. У Azure Portal створіть Virtual Machine Scale Set (VMSS), змінюючи лише наведені параметри.

   - Basics:
     - Subscription: Azure for Students.
     - Resource group: `rg-vmss-xxx-yyy-zzz`.
     - Virtual machine scale set name: `vmss-xxx-yyy-zzz-001`.
     - Availability zone: Zone 1 та Zone 2.
     - Orchestration mode: Flexible.
     - Scaling mode: Manually update the capacity.
     - Instance count: `2`.
     - Image: Ubuntu Server 24.04 LTS – x64 Gen2.
     - VM architecture: x64.
     - Size: Standard_B2s.
     - Authentication type: SSH public key.
     - Username: такий, як в Azure Cloud Shell.
     - SSH public key source: Generate new key pair, SSH Key Type: Ed25519 SSH format.

   - Disks:
     - OS disk type: Standard SSD (LRS).

   - Networking:
     - Select a load balancer → Create a load balancer → Name `lb-xxx-yyy-zzz-001`.

   - Advanced → Custom data and cloud init: застосуйте сценарій, що встановлює NGINX і додає вітальний текст:

```yaml
#cloud-config
package_update: true
packages:
    - nginx

write_files:
    - path: /var/www/html/index.html
    permissions: "0644"
    content: |
        placeholder

runcmd:
    - systemctl enable nginx
    - systemctl restart nginx
    - bash -lc 'echo "Hello from $(hostname)" > /var/www/html/index.html'
```

   Після перевірки параметрів натисніть Review + Create і дочекайтеся завершення розгортання.

11. Відкрийте створений VMSS і в Properties → Networking перейдіть до пов'язаного Load Balancer. На вкладці Monitoring → Insights відстежуйте стан health probes, дочекайтесь статусу Healthy. Потім у Frontend IP configuration скопіюйте IP address і в Azure Cloud Shell (PowerShell) виконайте перевірку балансування:

    ```powershell
    1..10 | ForEach-Object { (Invoke-WebRequest -Uri "http://<PUBLIC_IP>").Content }
    ```

    Переконайтесь, що відповіді містять різні hostnames — це підтверджує роботу NGINX на всіх інстансах.

12. У Virtual Machine Scale Set → Instances видаліть один довільний інстанс (має залишитися 1), щоб відстежити його повторне створення.

13. Налаштуйте правило autoscale для збільшення кількості інстансів за перевищення метрики CPU: Availability + scale → Scaling → Configure → Custom autoscale.

- Scale mode: Scale based on a metric.
- Rules → Add a rule:
    - Operator: Greater than
    - Metric threshold: `70%`
    - Duration: `5` хв
    - Time grain statistic: Average
    - Time aggregation: Average
    - Operation: Increase count by
    - Instance count: `1`
    - Cool down: `5` хв
- Instance limits: Minimum `1`, Maximum `2`, Default `1`.
- Save.

14. Додайте правило для зменшення кількості інстансів (scale in):

- Operator: Less than
- Metric threshold: `30%`
- Duration: `5` хв
- Operation: Decrease count by
- Instance count: `1`
- Add → Save.

15. Створіть навантаження на один із інстансів: Instances → оберіть VM → Operations → Run command → RunShellScript та виконайте:

    ```bash
    while :; do :; done &
    ```

    Це підвищить CPU та має запустити масштабування.

16. Через ~5 хвилин на сторінці Instances оновіть список і переконайтеся, що з'явився додатковий інстанс. За потреби повторіть крок 15.

17. Завершіть процеси, створені скриптом, та дочекайтеся повернення кількості інстансів до початкового значення відповідно до правила scale-in.

18. Видаліть усі ресурси із задіяної ресурсної групи, щоб уникнути зайвих витрат.

---

### Azure App Service на Linux та Deployment Slots (кроки 19–25)

19. Створіть App Service → Web App для PHP на Linux, змінюючи лише зазначені параметри.

   - Basics:
     - Subscription: Azure for Students.
     - Resource group: `rg-app-linux-php-xxx-yyy-zzz`.
     - Name: `app-linux-php-xxx-yyy-zzz-001` (вимкніть Try a secure unique default hostname).
     - Publish: Code.
     - Runtime stack: PHP 8.4.
     - Operating system: Linux.
     - Region: відповідає політиці Allowed regions.
     - App Service Plan → Create new: Name `asp-linux-php-xxx-yyy-zzz-001`, Pricing plan Standard S1.
     - Zone redundancy: Disabled.

   Після валідації натисніть Create і перевірте роботу застосунку: App Service → Overview → Browse.

20. Додайте deployment slot для тестування: Deployment → Deployment slots → Add Slot з Name `staging`, Clone settings from `Do not clone settings`. Зафіксуйте Default domain для staging і production слотів та перегляньте App Service plan → Apps(s) / Slots.

21. Налаштуйте розгортання зі зразкового репозиторію.

   - Settings → Configuration (preview) → Platform settings: увімкніть SCM Basic Auth Publishing Credentials → Apply.
   - Перейдіть до `staging`-слоту: Deployment → Deployment Center:
     - Source: External Git
     - Repository: `https://github.com/Azure-Samples/php-docs-hello-world`
     - Branch: `master`
     - Repository type: Public
   - Save і Sync. Після успішного деплою відкрийте staging через Overview → Browse й переконайтеся, що з'явився "Hello World!" застосунок.

22. Виконайте swap слотів: Deployment slots → Swap (Source = `staging`, Target = `production`) → Start Swap. Після операції перевірте обидва домени через Browse та зафіксуйте їх Default domains.

23. Налаштуйте autoscale для App Service Plan: App Service plan → Scale out → Configure.

- Scale mode: Scale based on a metric.
- Instance limits: Minimum `1`, Maximum `2`, Default `1`.
- Rules → Add a rule:
    - Metric namespace: Standard metrics
    - Metric name: CPU Percentage
    - Dimension values: All values
    - Operator: Greater than
    - Metric threshold: `70%`
    - Duration: `5` хв
    - Time grain statistics: Average
    - Time aggregation: Average
    - Operation: Increase count by
    - Instance count: `1`
    - Cooldown: `5` хв
- Add → Save.

24. Запустіть навантажувальний тест через Diagnose and solve problems → Load Test your App → Create Load Test:

- Name: `lt-linux-php-xxx-yyy-zzz-001`
- Region: такий самий, як у App Service
- Після створення: Create by adding HTTP requests → Test plan → Requests → Add request із URL production-слоту (починається з `https://`) → Review + Create → Create.
- Під час тесту відстежуйте App Service plan → Scale out → Run history та Overview (Instance count має збільшитись до 2). У Activity log зафіксуйте подію масштабування.

25. Після завершення тесту зупиніть його та видаліть створену ресурсну групу, щоб не витрачати кредити.

---

### Azure App Service на Windows (.NET) та GitHub Actions (кроки 26–33)

26. Створіть публічний репозиторій GitHub:

- Repository name: `app-win-dotnet-xxx-yyy-zzz-001`
- Description: `Lab 6 .NET app deployment test`
- Visibility: Public
- Додайте README, .gitignore (шаблон Dotnet) та ліцензію Apache 2.0. Create repository.

27. У Azure Cloud Shell (PowerShell) перевірте версію .NET:

    ```powershell
    dotnet --info | Select-String version
    ```

    Зафіксуйте версію для використання під час створення App Service.

28. Створіть Windows Web App у Azure Portal:

- Resource group: `rg-app-win-dotnet-xxx-yyy-zzz`
- Name: `app-win-dotnet-xxx-yyy-zzz-001` (вимкніть Try a secure unique default hostname)
- Publish: Code
- Runtime stack: виберіть версію .NET з кроку 27
- Operating system: Windows
- App Service Plan → Create new: Name `asp-win-dotnet-xxx-yyy-zzz-001`, Pricing plan Standard S1
- Zone redundancy: Disabled

   Після деплою перевірте роботу застосунку: Overview → Browse.

29. У Cloud Shell:

- Клонуйте репозиторій: `git clone <REPO_URL>`
- Створіть застосунок: `dotnet new webapp`
- Запустіть його:

```bash
    dotnet run --urls "http://localhost:5005"
```

- У новій Cloud Shell-сесії перевірте роботу:

```bash
curl http://localhost:5005
curl -I http://localhost:5005
```

   - Зупиніть застосунок комбінацією Ctrl + C.

30. Згенеруйте GitHub Personal Access Token (PAT): Settings → Developer Settings → Personal access tokens → Fine-grained token → Generate new token з назвою `pat-app-win-dotnet-xxx-yyy-zzz-001`, доступом лише до потрібного репозиторію та мінімальними правами для git push. Збережіть токен.

31. Налаштуйте git та завантажте код у GitHub:

    ```bash
    git config --global user.email "you@example.com"
    git config --global user.name "Your Name"
    git add .
    git commit -m "add initial .NET app"
    git push
    ```

    Під час першого `git push` використайте GitHub username та PAT (як пароль). Перевірте, що файли зʼявилися в репозиторії.

32. Підʼєднайте App Service до GitHub Actions: Deployment → Deployment Center → Source: GitHub, оберіть створений репозиторій та гілку `main`, Workflow option: Add a workflow, Authentication type: User-assigned identity, вкажіть підписку Azure for Students та прийміть ідентичність за замовчуванням. Збережіть і дочекайтесь успішного деплою (перевіряється через Overview → Browse).

33. Видаліть використані ресурси в Azure (обов'язково) та, за потреби, GitHub-репозиторій (опціонально).

---

### Контейнеризація, Azure Container Registry та Azure Container Instances (кроки 34–43)

34. Встановіть локально Azure CLI та Docker Desktop для своєї ОС (посилання в оригіналі).

35. У WSL або Bash-терміналі авторизуйтеся в Azure та підготуйте ресурси:

    ```bash
    az login                                    # автентифікація
    az provider register --namespace Microsoft.ContainerRegistry

    LOCATION=<обраний регіон>
    RG_NAME=<rg-dotnet-containers-xxx-yyy-zzz>
    ACR_NAME=<acrdotnetcontainersxxxyyyzzz>
    ACR_SKU=Standard

    az group create -l "$LOCATION" -n "$RG_NAME"
    az acr create -l "$LOCATION" -n "$ACR_NAME" -g "$RG_NAME" --sku "$ACR_SKU"
    az acr login -n "$ACR_NAME"
    ```

36. Клонуйте репозиторій dotnetcore-docs-hello-world, зберіть Docker-образ і завантажте його в ACR:

    ```bash
    docker build -f Dockerfile.linux -t "$ACR_NAME.azurecr.io/dotnetcore-docs-hello-world-linux" .
    docker images | grep "$ACR_NAME"
    docker push "$ACR_NAME.azurecr.io/dotnetcore-docs-hello-world-linux:latest"
    ```

    Якщо `docker build` завершується помилкою, замініть вміст `Dockerfile.linux` на варіант нижче та повторіть:

    ```dockerfile
    FROM mcr.microsoft.com/dotnet/sdk:8.0 AS build
    WORKDIR /source
    SHELL ["/bin/sh","-c"]
    COPY . ./dotnetcore-docs-hello-world/
    WORKDIR /source/dotnetcore-docs-hello-world
    RUN dotnet publish -c Release -o /app

    FROM mcr.microsoft.com/dotnet/aspnet:8.0
    WORKDIR /app
    COPY --from=build /app/ ./
    ENV ASPNETCORE_URLS=http://0.0.0.0:80
    EXPOSE 80
    ENTRYPOINT ["dotnet","dotnetcoresample.dll"]
    ```

37. Створіть контейнеризований App Service:

- Resource group: та сама, що містить ACR.

- Name: `app-dotnet-linux-container-xxx-yyy-zzz-001` (вимкніть Try a secure unique default hostname).
- Publish: Container, OS: Linux.
- App Service Plan → Create new: `asp-dotnet-linux-container-xxx-yyy-zzz-001`, Standard S1.
- Container settings:
    - Image source: Azure Container Registry.
    - Registry: оберіть створений ACR.
    - Authentication: Managed identity (створити нову identity).
    - Image: `dotnetcore-docs-hello-world-linux`, Tag: `latest`, Port: `80`.

Після створення дочекайтесь ініціалізації (до 5 хв). Перевірте логи:

- Deployment → Deployment Center → View logs (реальний час).
- Вкладка Logs у Deployment Center (очікуйте записи "Container is running" та "Site startup probe succeeded").

   Перевірте доступність застосунку: Overview → Browse.

38. Видаліть App Service та відповідний App Service Plan. У ресурсній групі мають залишитися лише ACR та створена managed identity.

39. Підготуйте підписку до роботи з Azure Container Instances (ACI) та ввімкніть адмін-доступ до ACR (для навчальних цілей):

    ```bash
    az provider register --namespace Microsoft.ContainerInstance
    az acr update -n "$ACR_NAME" --admin-enabled true
    ```

40. Розгорніть публічний контейнер NGINX в ACI:

    ```bash
    az container create \
      --name aci-nginx \
      --resource-group "$RG_NAME" \
      --image nginx:latest \
      --os-type Linux \
      --dns-name-label aci-nginx-$RANDOM \
      --cpu 1 \
      --memory 1 \
      --query ipAddress.fqdn \
      --output tsv
    ```

    Скопіюйте отриманий FQDN, зачекайте до хвилини на ініціалізацію та відкрийте адресу в браузері.

    ![Отриманий FQDN контейнера ACI](images/media/image1.png)
    *Рис. 1. FQDN, повернутий під час створення Azure Container Instance.*

    ![Сторінка за замовчуванням NGINX](images/media/image2.png)
    *Рис. 2. Доступ до контейнера NGINX у Azure Container Instance.*

    У Azure Portal відкрийте ресурс групи, оберіть ACI та зробіть скріншоти вкладок **Overview**, **Settings > Containers**, **Settings > Properties** та **Settings > Logs**.

41. Видаліть контейнер `aci-nginx` через портал. У **Resource group > Activity log** знайдіть подію з **Operation name** `Delete Container Group` та переконайтеся, що вона відповідає видаленому контейнеру (подія може зʼявитися через 3–5 хвилин).

42. Запустіть контейнер із приватного ACR.

- Переконайтеся, що змінні не порожні, і виконайте:

```bash
ACR_NAME=$(az acr list --query "[0].name" -o tsv)
az acr login -n "$ACR_NAME"
ACR_REPO_NAME=$(az acr repository list -n "$ACR_NAME" -o tsv)
ACR_IMAGE_TAG=$(az acr repository show-tags --name "$ACR_NAME" --repository "$ACR_REPO_NAME" --output tsv)
ACR_USERNAME=$(az acr credential show --name "$ACR_NAME" --query username -o tsv)
ACR_PASSWORD=$(az acr credential show --name "$ACR_NAME" --query "passwords[0].value" -o tsv)
```

   - Створіть ACI з приватним образом:

```bash
az container create \
--name aci-dotnet-container \
--resource-group "$RG_NAME" \
--image "$ACR_NAME.azurecr.io/$ACR_REPO_NAME:$ACR_IMAGE_TAG" \
--os-type Linux \
--dns-name-label aci-dotnet-container-$RANDOM \
--registry-login-server "$ACR_NAME.azurecr.io" \
--registry-username "$ACR_USERNAME" \
--registry-password "$ACR_PASSWORD" \
--cpu 1 \
--memory 1 \
--query ipAddress.fqdn \
--output tsv
```

- Скопіюйте FQDN і відкрийте застосунок у браузері. Якщо сторінка не завантажується, перевірте порт у Settings > Containers > Logs та, за потреби, видаліть контейнер і створіть його з явним відкриттям потрібних портів:

```bash
az container create \
    --name aci-dotnet-container \
    --resource-group "$RG_NAME" \
    --image "$ACR_NAME.azurecr.io/$ACR_REPO_NAME:$ACR_IMAGE_TAG" \
    --os-type Linux \
    --ports 80 8080 \
    --dns-name-label aci-dotnet-container-$RANDOM \
    --registry-login-server "$ACR_NAME.azurecr.io" \
    --registry-username "$ACR_USERNAME" \
    --registry-password "$ACR_PASSWORD" \
    --cpu 1 \
    --memory 1 \
    --query ipAddress.fqdn \
    --output tsv
```

![FQDN приватного контейнера ACI](images/media/image3.png)
*Рис. 3. FQDN, отриманий під час створення приватного контейнера.*

![Логи контейнера з відкритим портом](images/media/image4.png)
*Рис. 4. Визначення порту, на якому працює .NET-додаток усередині контейнера.*

![Працюючий .NET застосунок у ACI](images/media/image5.png)
*Рис. 5. Результат доступу до контейнеризованого .NET-додатку.*

Зафіксуйте скріншоти вкладок **Overview**, **Settings > Containers**, **Settings > Properties** та **Settings > Logs** для цього контейнера.

43. Видаліть усі ресурси, створені в межах лабораторної роботи.

---

## Контрольні запитання

1. Які параметри (Availability Set, тип безпеки, образ, розмір, регіон) впливають на доступність і продуктивність Virtual Machine, та як вони взаємоповʼязані?
2. Як планування адресного простору (CIDR, вибір префікса /29 чи /24) впливає на кількість доступних IP-адрес і можливість масштабування віртуальної мережі?
3. У чому різниця між дозволом RDP лише з My IP у правилі Inbound port rule та відкриттям порту для Any? Які ризики супроводжують кожен підхід?
4. Чому після додавання додаткового диска до VM він не зʼявляється у File Explorer одразу? Опишіть послідовність ініціалізації та монтування в Disk Management.
5. Ви встановили IIS, але вебсторінка за публічною IP-адресою не відкривається. Чому так сталося та як правильно налаштувати правила NSG для HTTP-доступу?
6. Чим відрізняється Virtual Machine Scale Set у режимі Flexible orchestration від окремих VM? Як у цьому сценарії автоматично налаштовується вебсервер через cloud-init?
7. Як працює звʼязка Azure Load Balancer + VMSS (frontend IP, backend pool, health probe, load-balancing rule) та як практично перевірити балансування запитів?
8. Як налаштовується autoscale для VMSS й App Service? Які метрики, пороги та значення cooldown використовуються та як підтвердити їхню роботу?
9. У чому різниця між App Service (Code) та App Service (Container)? Як організувати безперервне розгортання через GitHub і Deployment Slots?
10. Опишіть процес роботи з Azure Container Registry та Azure Container Instances: автентифікація, публікація Docker-образу, запуск контейнера й перевірка результату.
